#include "SkinDefs.r"

resource 'Skin' (1) {
	1,							/* Skin version - must be 1 for this skin structure */
	"Basique HR",				/* Skin name - can be 23 chars + zero at the end */
	SONY,						/* High resolution mode */
	4,							/* Minimal supported color depth */
	

	16,						/* Title height */
	YES,						/* Standard Palm OS title with time */
	0,							/* Title bar bitmap ID */
	{0, 0, 0, 0},			/* Title bar rectangle */

	8002,						/* Refresh button bitmap ID */
	8010,						/* Refresh button selected bitmap ID */
	{40, 2, 10, 10},		/* Refresh button rectangle */

	8003,						/* Memory bitmap ID */
	{53, 1, 31, 12},		/* Memory - the full size rectangle */
	{54, 3, 27, 7},		/* Memory - bar display rectangle */
	220,						/* Memory - delimiting vertical line color color */
	6,							/* Memory - delimiting vertical line color gray */

	8004,						/* Battery bitmap ID */
	8025,						/* Battery charging bitmap ID */
	{85, 1, 31, 12},		/* Battery - the full size rectangle */
	{86, 2, 25, 8},		/* Battery - bar display rectangle */
	64,						/* Battery - delimiting vertical line color color */
	10,						/* Battery - delimiting vertical line color gray */
	
	8014,						/* Homer bitmap ID */
	8021,						/* Homer selected bitmap ID */
	{0, 154, 9, 6},		/* Homer bitmap rectangle */
	{0, 154, 9, 6},		/* Homer hot-spot rectangle */

	8013,						/* Gadget toggle bitmap ID */
	8020,						/* Gadget toggle selected bitmap ID */
	{151, 154, 9, 6},	/* Gadget toggle bitmap rectangle */
	{151, 154, 9, 6},	/* Gadget toggle hot-spot rectangle */

	8012,						/* Gadget bar background bitmap ID */
	{0, 141, 160, 19},	/* Gadget bar background rectangle */

	8,							/* Number of visible gadgets (max is 16) */
	NO,						/* Gadgets vertical */
	{10, 143},				/* starting point for drawing gadgets */
	4,							/* gadget horizontal padding */
	14,						/* gadget width */
	16,						/* gadget height */
	
	13,						/* Number of gadgets */
	8100,						/* First gadget bitmap ID */
	8200,						/* First gadget selected bitmap ID */
	
	{3, 16, 150, 137},	/* App area - gadgets hidden*/
	{1, 16, 152, 125},	/* App area - gadgets drawn*/
	
	DEFAULT,					/* Scrollbar position */
	7,							/* Scrollbar width */
	0,							/* Scrollbar background color color */
	0,							/* Scrollbar background color gray */
	89,						/* Scrollbar foreground color color */
	15,						/* Scrollbar foreground color gray */
	3,							/* Scrollbar vertical size correction */

	10,						/* Number of category icons */
	4400,						/* First category icon bitmap ID */
	11,						/* Category icon width */
	10							/* Category icon height */
	};
